//Falcon-180B DATASET v1.0 Category: Recursive ; Style: Ada Lovelace
#include <stdio.h>

#define MAX 100

// Function to print an array
void printArray(int arr[], int size) {
    int i;
    for (i=0; i < size; i++)
        printf("%d ", arr[i]);
    printf("\n");
}

// Recursive function to generate permutations of an array
void permute(int arr[], int l, int r) {
    static int next[MAX]; // array to hold next permutation
    int i;

    // Base case: if left >= right, print the permutation
    if (l >= r) {
        for (i=l; i<=r; i++)
            printf("%d ", arr[i]);
        printf("\n");
        return;
    }

    // Permute the array from left to right
    for (i=l; i<=r; i++) {
        // Swap arr[l] with arr[i]
        int temp = arr[l];
        arr[l] = arr[i];
        arr[i] = temp;

        // Recursively generate permutations of the remaining elements
        permute(arr, l+1, r);

        // Backtrack to restore the original array
        temp = arr[l];
        arr[l] = arr[i];
        arr[i] = temp;
    }
}

// Driver program to test above functions
int main() {
    int arr[] = {1, 2, 3};
    int n = sizeof(arr)/sizeof(arr[0]);

    printf("Original array:\n");
    printArray(arr, n);

    printf("Permutations of the array:\n");
    permute(arr, 0, n-1);

    return 0;
}