//GPT-4o-mini DATASET v1.0 Category: Network Topology Mapper ; Style: portable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_DEVICES 20
#define MAX_NAME_LENGTH 50

typedef struct Device {
    char name[MAX_NAME_LENGTH];
    int connections[MAX_DEVICES];
    int conn_count;
} Device;

Device network[MAX_DEVICES];
int device_count = 0;

// Function to add a device
void add_device(const char *name) {
    if (device_count >= MAX_DEVICES) {
        printf("Error: Maximum device limit reached.\n");
        return;
    }
    strcpy(network[device_count].name, name);
    network[device_count].conn_count = 0;
    device_count++;
}

// Function to connect two devices
void connect_devices(const char *name1, const char *name2) {
    int index1 = -1, index2 = -1;

    for (int i = 0; i < device_count; i++) {
        if (strcmp(network[i].name, name1) == 0) {
            index1 = i;
        }
        if (strcmp(network[i].name, name2) == 0) {
            index2 = i;
        }
    }

    if (index1 == -1 || index2 == -1) {
        printf("Error: One or both devices not found.\n");
        return;
    }

    network[index1].connections[network[index1].conn_count++] = index2;
    network[index2].connections[network[index2].conn_count++] = index1; // Bi-directional connection
}

// Function to display the network topology
void display_topology() {
    printf("Network Topology:\n");

    for (int i = 0; i < device_count; i++) {
        printf("Device: %s\n", network[i].name);
        printf("Connections: ");
        for (int j = 0; j < network[i].conn_count; j++) {
            printf("%s ", network[network[i].connections[j]].name);
        }
        printf("\n\n");
    }
}

// Function to clean up network
void cleanup_network() {
    // In this example, no dynamic memory is used, but normally you would free any allocated memory
    device_count = 0;
}

// Main function
int main() {
    add_device("Router");
    add_device("Switch");
    add_device("PC1");
    add_device("PC2");
    add_device("Server");

    connect_devices("Router", "Switch");
    connect_devices("Switch", "PC1");
    connect_devices("Switch", "PC2");
    connect_devices("Switch", "Server");

    display_topology();

    cleanup_network();
    return 0;
}