//Falcon-180B DATASET v1.0 Category: TCP/IP Programming ; Style: brave
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <fcntl.h>

int main()
{
    int server_socket, client_socket, bytes_received;
    struct sockaddr_in server_addr, client_addr;
    char buffer[1024];

    // Create socket
    server_socket = socket(AF_INET, SOCK_STREAM, 0);
    if (server_socket == -1)
    {
        printf("Error creating socket");
        exit(1);
    }

    printf("Socket created\n");

    // Set server address
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(8080);
    inet_pton(AF_INET, "127.0.0.1", &server_addr.sin_addr);

    // Bind socket to address
    if (bind(server_socket, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0)
    {
        printf("Error binding socket");
        exit(1);
    }

    printf("Socket bound\n");

    // Listen for connections
    if (listen(server_socket, 5) < 0)
    {
        printf("Error listening on socket");
        exit(1);
    }

    printf("Listening on socket\n");

    // Accept connection
    client_socket = accept(server_socket, (struct sockaddr *)&client_addr, sizeof(client_addr));
    if (client_socket == -1)
    {
        printf("Error accepting connection");
        exit(1);
    }

    printf("Connection accepted\n");

    // Send data to client
    bytes_received = send(client_socket, "Hello from server", strlen("Hello from server"), 0);
    if (bytes_received == -1)
    {
        printf("Error sending data");
        exit(1);
    }

    printf("Data sent to client\n");

    // Receive data from client
    bytes_received = recv(client_socket, buffer, sizeof(buffer), 0);
    if (bytes_received == -1)
    {
        printf("Error receiving data");
        exit(1);
    }

    printf("Data received from client: %s\n", buffer);

    // Close sockets
    close(server_socket);
    close(client_socket);

    return 0;
}