//GEMINI-pro DATASET v1.0 Category: Levenshtein Distance Calculator ; Style: peaceful
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define MIN(a, b) ((a) < (b) ? (a) : (b))

int levenshtein(char *s1, char *s2)
{
  int s1len = strlen(s1);
  int s2len = strlen(s2);

  // Create a matrix to store the distances
  int matrix[s1len + 1][s2len + 1];

  // Initialize the first row and column of the matrix
  for (int i = 0; i <= s1len; i++)
  {
    matrix[i][0] = i;
  }
  for (int j = 0; j <= s2len; j++)
  {
    matrix[0][j] = j;
  }

  // Calculate the distances
  for (int i = 1; i <= s1len; i++)
  {
    for (int j = 1; j <= s2len; j++)
    {
      int cost = (s1[i - 1] == s2[j - 1]) ? 0 : 1;
      matrix[i][j] = MIN(MIN(matrix[i - 1][j] + 1, matrix[i][j - 1] + 1), matrix[i - 1][j - 1] + cost);
    }
  }

  // Return the distance
  return matrix[s1len][s2len];
}

int main()
{
  char s1[] = "Hello";
  char s2[] = "World";

  // Calculate the Levenshtein distance
  int distance = levenshtein(s1, s2);

  // Print the distance
  printf("The Levenshtein distance between \"%s\" and \"%s\" is %d\n", s1, s2, distance);

  return 0;
}