//GEMINI-pro DATASET v1.0 Category: Internet Speed Test Application ; Style: accurate
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <time.h>
#include <unistd.h>
#include <curl/curl.h>

#define URL "https://www.example.com"
#define BUF_SIZE 1024

struct speed_test_data {
  double start_time;
  double end_time;
  size_t data_size;
};

static size_t write_data(void *buffer, size_t size, size_t nmemb, void *userp) {
  struct speed_test_data *data = (struct speed_test_data *)userp;
  data->data_size += size * nmemb;
  return size * nmemb;
}

double get_speed(const char *url) {
  CURL *curl;
  CURLcode res;
  struct speed_test_data data = {0};
  struct timeval start, end;

  curl = curl_easy_init();
  if (!curl) {
    return -1;
  }

  curl_easy_setopt(curl, CURLOPT_URL, url);
  curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, write_data);
  curl_easy_setopt(curl, CURLOPT_WRITEDATA, &data);
  curl_easy_setopt(curl, CURLOPT_CONNECTTIMEOUT, 10);
  curl_easy_setopt(curl, CURLOPT_TIMEOUT, 10);

  gettimeofday(&start, NULL);
  res = curl_easy_perform(curl);
  gettimeofday(&end, NULL);

  if (res != CURLE_OK) {
    fprintf(stderr, "curl_easy_perform() failed: %s\n", curl_easy_strerror(res));
    curl_easy_cleanup(curl);
    return -1;
  }

  data.end_time = end.tv_sec + (end.tv_usec / 1000000.0);
  data.start_time = start.tv_sec + (start.tv_usec / 1000000.0);

  curl_easy_cleanup(curl);

  return data.data_size / (data.end_time - data.start_time);
}

int main(int argc, char **argv) {
  double speed;

  if (argc != 2) {
    fprintf(stderr, "Usage: %s url\n", argv[0]);
    return EXIT_FAILURE;
  }

  speed = get_speed(argv[1]);
  if (speed < 0) {
    fprintf(stderr, "Error getting speed\n");
    return EXIT_FAILURE;
  }

  printf("Speed: %.2f KB/s\n", speed);

  return EXIT_SUCCESS;
}