//GEMINI-pro DATASET v1.0 Category: Sentiment analysis tool ; Style: recursive
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define sentiment scores for words
int scores[256];

// Initialize sentiment scores
void init_scores() {
  for (int i = 0; i < 256; i++) {
    scores[i] = 0;
  }
  scores['a'] = 1;
  scores['b'] = 2;
  scores['c'] = 3;
  scores['d'] = 4;
  scores['e'] = 5;
  scores['f'] = 6;
  scores['g'] = 7;
  scores['h'] = 8;
  scores['i'] = 9;
  scores['j'] = 10;
  scores['k'] = 11;
  scores['l'] = 12;
  scores['m'] = 13;
  scores['n'] = 14;
  scores['o'] = 15;
  scores['p'] = 16;
  scores['q'] = 17;
  scores['r'] = 18;
  scores['s'] = 19;
  scores['t'] = 20;
  scores['u'] = 21;
  scores['v'] = 22;
  scores['w'] = 23;
  scores['x'] = 24;
  scores['y'] = 25;
  scores['z'] = 26;
}

// Calculate sentiment score for a word
int get_score(char c) {
  return scores[(int)c];
}

// Calculate sentiment score for a sentence
int get_sentence_score(char *sentence) {
  if (*sentence == '\0') {
    return 0;
  }
  return get_score(*sentence) + get_sentence_score(sentence + 1);
}

// Print sentiment score for a sentence
void print_score(char *sentence) {
  int score = get_sentence_score(sentence);
  printf("Sentiment score for '%s': %d\n", sentence, score);
}

int main() {
  init_scores();

  print_score("The quick brown fox jumps over the lazy dog.");
  print_score("The movie was really bad.");
  print_score("I love this song!");

  return 0;
}