//Falcon-180B DATASET v1.0 Category: Temperature monitor ; Style: sophisticated
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/i2c-dev.h>
#include <math.h>

int main()
{
    int file;
    int addr = 0x48;
    int temp_data;
    float temp_celsius;
    float temp_fahrenheit;
    char temp_string[20];

    // Open the I2C device
    file = open("/dev/i2c-1", O_RDWR);
    if (file < 0)
    {
        printf("Error opening I2C device\n");
        exit(1);
    }

    // Set the I2C address
    if (ioctl(file, I2C_SLAVE, addr) < 0)
    {
        printf("Error setting I2C address\n");
        exit(1);
    }

    // Read the temperature data
    if (read(file, &temp_data, sizeof(temp_data))!= sizeof(temp_data))
    {
        printf("Error reading temperature data\n");
        exit(1);
    }

    // Convert the temperature data to Celsius
    temp_celsius = (temp_data / 256.0) * 100.0;

    // Convert the temperature data to Fahrenheit
    temp_fahrenheit = (temp_celsius * 9.0 / 5.0) + 32.0;

    // Format the temperature data as a string
    sprintf(temp_string, "%.2f C / %.2f F", temp_celsius, temp_fahrenheit);

    // Print the temperature data
    printf("Temperature: %s\n", temp_string);

    // Close the I2C device
    close(file);

    return 0;
}