//GEMINI-pro DATASET v1.0 Category: Wireless Network Scanner ; Style: Linus Torvalds
#include <linux/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/ioctl.h>
#include <net/if.h>

#define MAX_INTERFACES 10

struct interface {
    char name[IFNAMSIZ];
    struct sockaddr_in addr;
};

int main() {
    int sockfd;
    struct ifreq ifr[MAX_INTERFACES];
    struct interface interfaces[MAX_INTERFACES];
    int num_interfaces = 0;

    // Create a socket
    sockfd = socket(AF_INET, SOCK_DGRAM, 0);
    if (sockfd == -1) {
        perror("socket");
        exit(1);
    }

    // Get a list of interfaces
    for (int i = 0; i < MAX_INTERFACES; i++) {
        ifr[i].ifr_addr.sa_family = AF_INET;
        snprintf(ifr[i].ifr_name, IFNAMSIZ, "wlan%d", i);
        if (ioctl(sockfd, SIOCGIFADDR, &ifr[i]) == -1) {
            break;
        }

        // Add the interface to the list
        memcpy(&interfaces[num_interfaces].name, ifr[i].ifr_name, IFNAMSIZ);
        memcpy(&interfaces[num_interfaces].addr, &ifr[i].ifr_addr, sizeof(struct sockaddr_in));
        num_interfaces++;
    }

    // Close the socket
    close(sockfd);

    // Print the list of interfaces
    printf("Network interfaces:\n");
    for (int i = 0; i < num_interfaces; i++) {
        printf("%s: %s\n", interfaces[i].name, inet_ntoa(interfaces[i].addr.sin_addr));
    }

    return 0;
}