//Falcon-180B DATASET v1.0 Category: Database querying ; Style: medieval
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ROWS 10
#define MAX_COLS 10
#define MAX_STR_LEN 100

typedef struct {
    char name[MAX_STR_LEN];
    int age;
    float height;
} Person;

typedef struct {
    Person data[MAX_ROWS][MAX_COLS];
    int num_rows;
    int num_cols;
} Table;

void create_table(Table *table) {
    table->num_rows = 0;
    table->num_cols = 0;
}

int add_row(Table *table) {
    if (table->num_rows >= MAX_ROWS) {
        printf("Table is full. Cannot add more rows.\n");
        return -1;
    }
    table->num_rows++;
    return 0;
}

int add_col(Table *table) {
    if (table->num_cols >= MAX_COLS) {
        printf("Table is full. Cannot add more columns.\n");
        return -1;
    }
    table->num_cols++;
    return 0;
}

int insert_data(Table *table, int row, int col, Person person) {
    if (row >= table->num_rows || col >= table->num_cols) {
        printf("Invalid row or column.\n");
        return -1;
    }
    table->data[row][col] = person;
    return 0;
}

int display_table(Table *table) {
    int i, j;
    for (i = 0; i < table->num_rows; i++) {
        for (j = 0; j < table->num_cols; j++) {
            printf("%s %d %.2f\n", table->data[i][j].name, table->data[i][j].age, table->data[i][j].height);
        }
    }
}

int main() {
    Table table;
    create_table(&table);
    add_row(&table);
    add_col(&table);
    Person p1 = {"John", 25, 180.5};
    Person p2 = {"Mary", 30, 165.3};
    Person p3 = {"Bob", 40, 195.7};
    insert_data(&table, 0, 0, p1);
    insert_data(&table, 0, 1, p2);
    insert_data(&table, 0, 2, p3);
    display_table(&table);
    return 0;
}