//Code Llama-13B DATASET v1.0 Category: Sorting ; Style: ultraprecise
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>

// Structure to represent a single data item
typedef struct {
  int key;
  char name[50];
} Data;

// Function to swap two data items
void swap(Data *a, Data *b) {
  Data temp = *a;
  *a = *b;
  *b = temp;
}

// Function to sort an array of data items in ascending order
void sort(Data *arr, int n) {
  // Loop through the array and find the smallest element
  for (int i = 0; i < n - 1; i++) {
    int min = i;
    for (int j = i + 1; j < n; j++) {
      if (arr[j].key < arr[min].key) {
        min = j;
      }
    }

    // Swap the smallest element with the first element
    swap(&arr[min], &arr[i]);
  }
}

int main() {
  // Initialize an array of data items
  Data arr[5] = {
    {1, "John"},
    {3, "Mary"},
    {2, "Peter"},
    {4, "Sarah"},
    {5, "Emily"}
  };

  // Sort the array
  sort(arr, 5);

  // Print the sorted array
  for (int i = 0; i < 5; i++) {
    printf("%s %d\n", arr[i].name, arr[i].key);
  }

  return 0;
}