//GEMINI-pro DATASET v1.0 Category: Weather simulation ; Style: safe
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <time.h>

// Weather types
enum weather_type {
    SUNNY,
    CLOUDY,
    RAINY,
    STORMY
};

// Weather struct
struct weather {
    enum weather_type type;
    float temperature;
    float humidity;
    float wind_speed;
};

// Function to generate a random weather struct
struct weather generate_random_weather() {
    struct weather weather;
    
    // Generate a random weather type
    weather.type = rand() % 4;
    
    // Generate a random temperature between 0 and 40 degrees Celsius
    weather.temperature = (float)(rand() % 41);
    
    // Generate a random humidity between 0 and 100%
    weather.humidity = (float)(rand() % 101);
    
    // Generate a random wind speed between 0 and 100 km/h
    weather.wind_speed = (float)(rand() % 101);
    
    return weather;
}

// Function to print the weather struct
void print_weather(struct weather weather) {
    printf("Weather type: %d\n", weather.type);
    printf("Temperature: %.2f degrees Celsius\n", weather.temperature);
    printf("Humidity: %.2f%%\n", weather.humidity);
    printf("Wind speed: %.2f km/h\n", weather.wind_speed);
}

// Function to simulate the weather for a given number of days
void simulate_weather(int num_days) {
    // Generate a random weather struct for each day
    struct weather weather[num_days];
    for (int i = 0; i < num_days; i++) {
        weather[i] = generate_random_weather();
    }
    
    // Print the weather for each day
    for (int i = 0; i < num_days; i++) {
        printf("Day %d:\n", i + 1);
        print_weather(weather[i]);
        printf("\n");
    }
}

int main() {
    // Seed the random number generator
    srand(time(NULL));
    
    // Simulate the weather for 7 days
    simulate_weather(7);
    
    return 0;
}