//MISTRAL-7B DATASET v1.0 Category: Weather simulation ; Style: Ada Lovelace
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_DAYS 5
#define NUM_WEATHERS 4
#define MIN_TEMP 0
#define MAX_TEMP 30

typedef enum Weather {
    SUNNY,
    RAINY,
    CLOUDY,
    SNOWY
} Weather;

void print_weather(Weather w) {
    switch (w) {
        case SUNNY:
            printf("Sunny\n");
            break;
        case RAINY:
            printf("Rainy\n");
            break;
        case CLOUDY:
            printf("Cloudy\n");
            break;
        case SNOWY:
            printf("Snowy\n");
            break;
        default:
            break;
    }
}

Weather get_weather() {
    return (Weather)(rand() % NUM_WEATHERS);
}

void print_temperature(int temp) {
    printf("%d°C\n", temp);
}

void simulate_day(int day) {
    Weather weather = get_weather();
    int temperature = rand() % (MAX_TEMP - MIN_TEMP + 1) + MIN_TEMP;

    printf("Day %d:\n", day);
    print_weather(weather);
    print_temperature(temperature);
    printf("\n");
}

int main() {
    srand(time(NULL));

    printf("Weather simulation by Ada Lovelace\n");
    printf("------------------------------------\n");

    for (int i = 0; i < NUM_DAYS; i++) {
        simulate_day(i + 1);
    }

    return 0;
}