//Gemma-7B DATASET v1.0 Category: Syntax parsing ; Style: multivariable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_BUFFER_SIZE 1024

void parse_c_syntax(char *buffer)
{
    int i = 0;
    int state = 0;
    char current_symbol = '\0';

    for (i = 0; buffer[i] != '\0'; i++)
    {
        switch (state)
        {
            case 0:
                if (buffer[i] == '{' || buffer[i] == '(' || buffer[i] == '[')
                {
                    current_symbol = buffer[i];
                    state = 1;
                }
                else if (buffer[i] == ' ')
                {
                    state = 2;
                }
                else
                {
                    printf("Error: Invalid syntax.\n");
                    exit(1);
                }
                break;

            case 1:
                if (buffer[i] == '}')
                {
                    state = 0;
                }
                else if (buffer[i] == ')')
                {
                    state = 0;
                }
                else if (buffer[i] == ']')
                {
                    state = 0;
                }
                else
                {
                    printf("Error: Missing closing parenthesis.\n");
                    exit(1);
                }
                break;

            case 2:
                if (buffer[i] == ' ')
                {
                    state = 0;
                }
                else
                {
                    printf("Error: Unexpected symbol.\n");
                    exit(1);
                }
                break;
        }
    }

    if (state != 0)
    {
        printf("Error: Incomplete syntax.\n");
        exit(1);
    }

    printf("Syntax parsed successfully.\n");
}

int main()
{
    char buffer[MAX_BUFFER_SIZE] = "int main() { return 0; }";

    parse_c_syntax(buffer);

    return 0;
}