//Falcon-180B DATASET v1.0 Category: Word Frequency Counter ; Style: unmistakable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stdbool.h>

#define MAX_WORDS 100000
#define MAX_WORD_LENGTH 50

typedef struct {
    char word[MAX_WORD_LENGTH + 1];
    int count;
} WordFrequency;

void add_word(WordFrequency* frequencies, int size, char* word) {
    for (int i = 0; i < size; i++) {
        if (strcmp(frequencies[i].word, word) == 0) {
            frequencies[i].count++;
            return;
        }
    }
    if (size < MAX_WORDS) {
        strcpy(frequencies[size].word, word);
        frequencies[size].count = 1;
        size++;
    }
}

void print_frequencies(WordFrequency* frequencies, int size) {
    for (int i = 0; i < size; i++) {
        printf("%s: %d\n", frequencies[i].word, frequencies[i].count);
    }
}

int main(int argc, char** argv) {
    if (argc < 2) {
        printf("Usage: %s <filename>\n", argv[0]);
        return 1;
    }

    FILE* file = fopen(argv[1], "r");
    if (file == NULL) {
        printf("Error opening file %s\n", argv[1]);
        return 1;
    }

    WordFrequency frequencies[MAX_WORDS];
    int size = 0;

    char word[MAX_WORD_LENGTH + 1];
    char* token;
    while ((token = strtok(NULL, " \t\n\r\f\v,.!?:;\"'"))!= NULL) {
        if (token[0] == '\0')
            continue;
        strcpy(word, token);
        char* word_lower = strdup(word);
        for (int i = 0; i < strlen(word_lower); i++) {
            word_lower[i] = tolower(word_lower[i]);
        }
        add_word(frequencies, size, word_lower);
        free(word_lower);
    }

    fclose(file);

    print_frequencies(frequencies, size);

    return 0;
}