//GEMINI-pro DATASET v1.0 Category: Word Count Tool ; Style: romantic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

typedef struct {
    int count;
    char *word;
} WordEntry;

int compareWords(const void *a, const void *b) {
    WordEntry *w1 = (WordEntry *)a;
    WordEntry *w2 = (WordEntry *)b;
    return strcmp(w1->word, w2->word);
}

int main() {
    char *text = NULL;
    size_t len = 0;
    ssize_t nread;

    // Read the text from the standard input
    printf("My dearest, pour your heart into a tale for me...\n");
    nread = getline(&text, &len, stdin);
    if (nread == -1) {
        perror("getline");
        return EXIT_FAILURE;
    }

    // Tokenize the text into words
    char *token = strtok(text, " ,.-?!;:\n");
    size_t nwords = 0;
    WordEntry *words = NULL;
    while (token != NULL) {
        // Convert token to lowercase
        for (char *c = token; *c != '\0'; c++) {
            *c = tolower(*c);
        }

        // Check if the word is already in the list
        int found = 0;
        for (size_t i = 0; i < nwords; i++) {
            if (strcmp(words[i].word, token) == 0) {
                words[i].count++;
                found = 1;
                break;
            }
        }

        // If the word is not in the list, add it
        if (!found) {
            words = realloc(words, (nwords + 1) * sizeof(WordEntry));
            words[nwords].count = 1;
            words[nwords].word = strdup(token);
            nwords++;
        }

        // Get the next token
        token = strtok(NULL, " ,.-?!;:\n");
    }

    // Sort the words in alphabetical order
    qsort(words, nwords, sizeof(WordEntry), compareWords);

    // Print the word count
    printf("Your love story, my muse, in numbers:\n");
    for (size_t i = 0; i < nwords; i++) {
        printf("%-20s %d\n", words[i].word, words[i].count);
    }

    // Free the memory
    free(text);
    for (size_t i = 0; i < nwords; i++) {
        free(words[i].word);
    }
    free(words);

    return EXIT_SUCCESS;
}