//Falcon-180B DATASET v1.0 Category: Public-Key Algorithm Implementation ; Style: curious
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the maximum size of the prime numbers
#define MAX_PRIME_SIZE 100

// Function prototypes
void generate_primes(int primes[], int size);
int is_prime(int num);
void generate_keys(int primes[], int size, int *public_key, int *private_key);
int encrypt(int message, int public_key);
int decrypt(int ciphertext, int private_key);

int main() {
    // Seed the random number generator with the current time
    srand(time(NULL));

    // Generate two prime numbers
    int primes[2];
    generate_primes(primes, 2);

    // Generate the public and private keys
    int public_key, private_key;
    generate_keys(primes, 2, &public_key, &private_key);

    // Encrypt a message
    int message = 42;
    int ciphertext = encrypt(message, public_key);

    // Decrypt the ciphertext
    int decrypted_message = decrypt(ciphertext, private_key);

    printf("Original message: %d\n", message);
    printf("Encrypted message: %d\n", ciphertext);
    printf("Decrypted message: %d\n", decrypted_message);

    return 0;
}

// Generate an array of prime numbers
void generate_primes(int primes[], int size) {
    int i;
    for (i = 0; i < size; i++) {
        primes[i] = rand() % MAX_PRIME_SIZE + 2; // Start with 2, the first prime number
    }
}

// Check if a number is prime
int is_prime(int num) {
    if (num <= 1) {
        return 0; // Numbers less than or equal to 1 are not prime
    }

    int i;
    for (i = 2; i <= num / 2; i++) {
        if (num % i == 0) {
            return 0; // If the number is divisible by any number between 2 and num/2, it is not prime
        }
    }

    return 1; // Otherwise, the number is prime
}

// Generate the public and private keys
void generate_keys(int primes[], int size, int *public_key, int *private_key) {
    // Choose two random prime numbers from the array
    int prime1 = primes[rand() % size];
    int prime2 = primes[rand() % size];

    // Make sure prime2 is larger than prime1
    if (prime1 > prime2) {
        int temp = prime1;
        prime1 = prime2;
        prime2 = temp;
    }

    // Calculate the public key
    *public_key = prime1 * prime2;

    // Calculate the private key
    int private_key1 = (prime1 - 1) * (prime2 - 1);
    int private_key2 = prime2 - 1;

    // Choose a random private key from the two possible keys
    if (rand() % 2 == 0) {
        *private_key = private_key1;
    } else {
        *private_key = private_key2;
    }
}

// Encrypt a message using the public key
int encrypt(int message, int public_key) {
    return (message * public_key) % MAX_PRIME_SIZE;
}

// Decrypt a ciphertext using the private key
int decrypt(int ciphertext, int private_key) {
    return (ciphertext * private_key) % MAX_PRIME_SIZE;
}