//Gemma-7B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: mathematical
#include <stdlib.h>
#include <stdio.h>
#include <time.h>

#define MAX_PROCESSES 10
#define MAX_SCHEDULE_SIZE 10

typedef struct Process {
  int process_id;
  int arrival_time;
  int burst_time;
  int waiting_time;
  int turn_around_time;
} Process;

Process processes[MAX_PROCESSES];

void round_robin(int quantum);

int main() {
  int i, j, quantum = 2;

  // Initialize processes
  for (i = 0; i < MAX_PROCESSES; i++) {
    processes[i].process_id = i + 1;
    processes[i].arrival_time = rand() % 10;
    processes[i].burst_time = rand() % 5;
  }

  // Round robin scheduling
  round_robin(quantum);

  // Calculate waiting time and turn-around time
  for (i = 0; i < MAX_PROCESSES; i++) {
    processes[i].waiting_time = processes[i].arrival_time - processes[i].burst_time;
    processes[i].turn_around_time = processes[i].waiting_time + processes[i].burst_time;
  }

  // Print results
  for (i = 0; i < MAX_PROCESSES; i++) {
    printf("Process ID: %d, Arrival Time: %d, Burst Time: %d, Waiting Time: %d, Turnaround Time: %d\n", processes[i].process_id, processes[i].arrival_time, processes[i].burst_time, processes[i].waiting_time, processes[i].turn_around_time);
  }

  return 0;
}

void round_robin(int quantum) {
  int current_process = 0;
  int time_quantum = quantum;
  int flag = 0;

  while (!flag) {
    time_quantum--;
    if (processes[current_process].burst_time > 0) {
      processes[current_process].burst_time--;
    } else {
      current_process++;
      if (current_process == MAX_PROCESSES) {
        current_process = 0;
      }
    }

    if (time_quantum == 0) {
      flag = 1;
    }
  }
}