//Falcon2-11B DATASET v1.0 Category: Text Summarizer ; Style: energetic
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

// Function to get the most frequent words in a sentence
int getMostFrequentWords(char* sentence, int maxWords)
{
    int count[26] = {0};
    int words[26] = {0};
    int i, j, maxCount = 0, maxIndex = -1;
    char ch;

    // Count the frequency of each letter in the sentence
    for (i = 0; i < strlen(sentence); i++)
    {
        ch = sentence[i];
        if (ch >= 'a' && ch <= 'z')
        {
            count[ch - 'a']++;
        }
    }

    // Get the most frequent words
    for (i = 0; i < 26; i++)
    {
        if (count[i] > maxCount)
        {
            maxCount = count[i];
            maxIndex = i;
        }
    }

    // Get the words that correspond to the most frequent letters
    for (i = 0; i < strlen(sentence); i++)
    {
        ch = sentence[i];
        if (ch >= 'a' && ch <= 'z')
        {
            if (ch == maxIndex + 'a')
            {
                words[maxCount]++;
            }
        }
    }

    // Sort the words based on their frequency
    for (i = 0; i < maxWords; i++)
    {
        for (j = i + 1; j < maxWords; j++)
        {
            if (words[i] > words[j])
            {
                char temp = words[i];
                words[i] = words[j];
                words[j] = temp;
            }
        }
    }

    // Print the most frequent words
    for (i = 0; i < maxWords; i++)
    {
        printf("%c: %d\n", maxIndex + 'a', words[i]);
    }

    return 0;
}

int main()
{
    char sentence[] = "The quick brown fox jumps over the lazy dog";
    int maxWords = 5;

    getMostFrequentWords(sentence, maxWords);

    return 0;
}