//Falcon-180B DATASET v1.0 Category: Graph Coloring Problem ; Style: post-apocalyptic
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

#define NUM_NODES 10
#define NUM_COLORS 6

int nodes[NUM_NODES];
int colors[NUM_COLORS];
int num_colors;

void init_colors(void) {
    int i;
    for (i = 0; i < NUM_COLORS; i++) {
        colors[i] = i;
    }
}

void print_colors(void) {
    int i;
    for (i = 0; i < num_colors; i++) {
        printf("%d ", colors[i]);
    }
    printf("\n");
}

bool is_valid_color(int color) {
    int i;
    for (i = 0; i < num_colors; i++) {
        if (colors[i] == color) {
            return true;
        }
    }
    return false;
}

void add_color(int color) {
    if (num_colors >= NUM_COLORS) {
        printf("Error: Too many colors\n");
        exit(1);
    }
    colors[num_colors++] = color;
}

int main(void) {
    int i, j;
    for (i = 0; i < NUM_NODES; i++) {
        nodes[i] = i;
    }
    init_colors();
    for (i = 0; i < NUM_NODES; i++) {
        for (j = 0; j < NUM_COLORS; j++) {
            if (is_valid_color(j)) {
                add_color(j);
            }
        }
    }
    print_colors();
    return 0;
}