//Falcon-180B DATASET v1.0 Category: Network Topology Mapper ; Style: systematic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NODES 100
#define MAX_LINKS 200
#define MAX_LINK_NAME 50
#define MAX_NODE_NAME 50

typedef struct {
    int id;
    char name[MAX_NODE_NAME];
} node;

typedef struct {
    int source;
    int destination;
    char name[MAX_LINK_NAME];
} link;

int num_nodes = 0;
int num_links = 0;
node nodes[MAX_NODES];
link links[MAX_LINKS];

void add_node(int id, char* name) {
    if (num_nodes >= MAX_NODES) {
        printf("Error: Maximum number of nodes reached.\n");
        exit(1);
    }
    nodes[num_nodes].id = id;
    strcpy(nodes[num_nodes].name, name);
    num_nodes++;
}

void add_link(int source, int destination, char* name) {
    if (num_links >= MAX_LINKS) {
        printf("Error: Maximum number of links reached.\n");
        exit(1);
    }
    links[num_links].source = source;
    links[num_links].destination = destination;
    strcpy(links[num_links].name, name);
    num_links++;
}

void print_nodes() {
    printf("Nodes:\n");
    for (int i = 0; i < num_nodes; i++) {
        printf("%d: %s\n", nodes[i].id, nodes[i].name);
    }
}

void print_links() {
    printf("Links:\n");
    for (int i = 0; i < num_links; i++) {
        printf("%s: %d -> %d\n", links[i].name, links[i].source, links[i].destination);
    }
}

int main() {
    add_node(1, "Node 1");
    add_node(2, "Node 2");
    add_node(3, "Node 3");
    add_node(4, "Node 4");
    add_node(5, "Node 5");

    add_link(1, 2, "Link 1");
    add_link(2, 3, "Link 2");
    add_link(3, 4, "Link 3");
    add_link(4, 5, "Link 4");

    print_nodes();
    print_links();

    return 0;
}