//GEMINI-pro DATASET v1.0 Category: Fitness Tracker ; Style: multivariable
#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <math.h>

typedef struct {
  int steps;
  int calories;
  int distance;
  int duration;
} fitness_data;

typedef struct {
  fitness_data data;
  time_t timestamp;
} fitness_record;

void print_fitness_record(fitness_record *record) {
  printf("Steps: %d\n", record->data.steps);
  printf("Calories: %d\n", record->data.calories);
  printf("Distance: %d\n", record->data.distance);
  printf("Duration: %d\n", record->data.duration);
  printf("Timestamp: %ld\n", record->timestamp);
}

int main() {
  // Initialize the fitness tracker with some random data
  srand(time(NULL));
  fitness_record records[10];
  for (int i = 0; i < 10; i++) {
    records[i].data.steps = rand() % 10000;
    records[i].data.calories = rand() % 1000;
    records[i].data.distance = rand() % 100;
    records[i].data.duration = rand() % 60;
    records[i].timestamp = time(NULL);
  }

  // Print the fitness records
  for (int i = 0; i < 10; i++) {
    print_fitness_record(&records[i]);
  }

  // Calculate the average steps, calories, distance, and duration
  int total_steps = 0;
  int total_calories = 0;
  int total_distance = 0;
  int total_duration = 0;
  for (int i = 0; i < 10; i++) {
    total_steps += records[i].data.steps;
    total_calories += records[i].data.calories;
    total_distance += records[i].data.distance;
    total_duration += records[i].data.duration;
  }
  float average_steps = (float)total_steps / 10;
  float average_calories = (float)total_calories / 10;
  float average_distance = (float)total_distance / 10;
  float average_duration = (float)total_duration / 10;

  // Print the average fitness data
  printf("Average steps: %.2f\n", average_steps);
  printf("Average calories: %.2f\n", average_calories);
  printf("Average distance: %.2f\n", average_distance);
  printf("Average duration: %.2f\n", average_duration);

  return 0;
}