//Falcon-180B DATASET v1.0 Category: Website Uptime Monitor ; Style: medieval
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curl/curl.h>

typedef struct {
    char *url;
    int interval;
    char *email;
    char *subject;
    char *body;
} config_t;

config_t config = {
   .url = "https://www.example.com",
   .interval = 60,
   .email = "admin@example.com",
   .subject = "Website Down",
   .body = "The website is down!"
};

size_t write_data(void *ptr, size_t size, size_t nmemb, FILE *stream) {
    size_t written = fwrite(ptr, size, nmemb, stream);
    return written;
}

int main() {
    CURL *curl;
    FILE *fp;
    CURLcode res;

    curl_global_init(CURL_GLOBAL_DEFAULT);
    curl = curl_easy_init();

    if(curl) {
        fp = fopen("log.txt", "a");
        if(fp) {
            curl_easy_setopt(curl, CURLOPT_URL, config.url);
            curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, write_data);
            curl_easy_setopt(curl, CURLOPT_WRITEDATA, fp);

            res = curl_easy_perform(curl);

            if(res!= CURLE_OK) {
                fprintf(fp, "Error: %s\n", curl_easy_strerror(res));
            } else {
                fprintf(fp, "Website is up!\n");
            }

            fclose(fp);
        } else {
            printf("Error: Failed to open log file.\n");
        }

        curl_easy_cleanup(curl);
    }

    curl_global_cleanup();
    return 0;
}