//Code Llama-13B DATASET v1.0 Category: Socket programming ; Style: visionary
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <unistd.h>

int main(int argc, char **argv) {
    int sock, new_sock;
    struct sockaddr_in server, client;
    char buffer[256];
    socklen_t client_len = sizeof(client);

    // Create the socket
    sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock == -1) {
        perror("socket creation failed");
        exit(1);
    }

    // Set up the server address
    server.sin_family = AF_INET;
    server.sin_addr.s_addr = INADDR_ANY;
    server.sin_port = htons(8000);

    // Bind the socket to the server address
    if (bind(sock, (struct sockaddr *)&server, sizeof(server)) < 0) {
        perror("bind failed");
        exit(1);
    }

    // Listen for incoming connections
    if (listen(sock, 3) < 0) {
        perror("listen failed");
        exit(1);
    }

    printf("Server listening on port 8000...\n");

    // Accept incoming connections
    new_sock = accept(sock, (struct sockaddr *)&client, &client_len);
    if (new_sock < 0) {
        perror("accept failed");
        exit(1);
    }

    printf("Client connected...\n");

    // Receive data from the client
    recv(new_sock, buffer, 256, 0);
    printf("Received message: %s\n", buffer);

    // Send data back to the client
    send(new_sock, "Hello, client!", 13, 0);

    // Close the socket
    close(sock);
    close(new_sock);

    return 0;
}