//GEMINI-pro DATASET v1.0 Category: Personal Finance Planner ; Style: authentic
#include <stdio.h>
#include <stdlib.h>

// User account
struct account {
    char name[30];
    double balance;
};

// Global variables
int num_accounts = 0;
struct account accounts[10];

// Function prototypes
void add_account(struct account new_account);
void print_accounts();
void deposit(int account_index, double amount);
void withdraw(int account_index, double amount);

// Main function
int main() {
    // Add some example accounts
    struct account account1 = {"John Doe", 1000.00};
    struct account account2 = {"Jane Smith", 2000.00};
    add_account(account1);
    add_account(account2);

    // Print the accounts
    print_accounts();

    // Deposit some money into the first account
    deposit(0, 500.00);

    // Print the accounts again
    print_accounts();

    // Withdraw some money from the second account
    withdraw(1, 300.00);

    // Print the accounts one last time
    print_accounts();

    return 0;
}

// Add an account to the list of accounts
void add_account(struct account new_account) {
    if (num_accounts < 10) {
        accounts[num_accounts] = new_account;
        num_accounts++;
    } else {
        printf("Error: Too many accounts. Maximum is 10.\n");
    }
}

// Print the list of accounts
void print_accounts() {
    for (int i = 0; i < num_accounts; i++) {
        printf("%s: $%.2f\n", accounts[i].name, accounts[i].balance);
    }
}

// Deposit money into an account
void deposit(int account_index, double amount) {
    if (account_index >= 0 && account_index < num_accounts) {
        accounts[account_index].balance += amount;
        printf("Deposited $%.2f into %s's account.\n", amount, accounts[account_index].name);
    } else {
        printf("Error: Invalid account index.\n");
    }
}

// Withdraw money from an account
void withdraw(int account_index, double amount) {
    if (account_index >= 0 && account_index < num_accounts) {
        if (accounts[account_index].balance >= amount) {
            accounts[account_index].balance -= amount;
            printf("Withdrew $%.2f from %s's account.\n", amount, accounts[account_index].name);
        } else {
            printf("Error: Insufficient funds in account.\n");
        }
    } else {
        printf("Error: Invalid account index.\n");
    }
}