//Falcon2-11B DATASET v1.0 Category: Procedurally Generated Maze ; Style: Ken Thompson
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_X 20
#define MAX_Y 20

typedef struct {
    int x;
    int y;
} Point;

void generateMaze(Point start, Point end) {
    srand(time(NULL));

    Point current = start;
    Point next = end;

    int x, y;
    int x_min = MAX_X - 1;
    int y_min = MAX_Y - 1;
    int x_max = 0;
    int y_max = 0;

    while (next.x!= start.x || next.y!= start.y) {
        if (current.x == x_min && current.y == y_min) {
            current.x = x_max + 1;
            current.y = y_min;
        } else if (current.x == x_min && current.y == y_max) {
            current.x = x_min;
            current.y = y_max - 1;
        } else if (current.x == x_max && current.y == y_min) {
            current.x = x_max - 1;
            current.y = y_min;
        } else if (current.x == x_max && current.y == y_max) {
            current.x = x_max;
            current.y = y_max - 1;
        } else {
            if (current.x < next.x) {
                current.x++;
            } else {
                current.x--;
            }
            if (current.y < next.y) {
                current.y++;
            } else {
                current.y--;
            }
        }
        next.x = current.x;
        next.y = current.y;
    }

    int visited[MAX_X][MAX_Y] = {0};
    int num_walls = 0;

    for (x = 0; x < MAX_X; x++) {
        for (y = 0; y < MAX_Y; y++) {
            if (x == current.x && y == current.y) {
                continue;
            }
            if (visited[x][y] == 1) {
                continue;
            }
            if (x == next.x && y == next.y) {
                continue;
            }
            if (x == x_min || x == x_max || y == y_min || y == y_max) {
                continue;
            }
            visited[x][y] = 1;
            num_walls++;
        }
    }

    printf("Maze generation complete.\n");
    printf("Number of walls: %d\n", num_walls);
}

int main() {
    Point start = {3, 3};
    Point end = {14, 19};
    generateMaze(start, end);

    return 0;
}