//Falcon-180B DATASET v1.0 Category: Password Strength Checker ; Style: interoperable
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdbool.h>
#include <stdlib.h>

#define MIN_LENGTH 8
#define MAX_LENGTH 32
#define NUM_CHARS 4
#define UPPER_CASE 1
#define LOWER_CASE 2
#define NUMBERS 4
#define SPECIAL_CHARS 8

int main() {
    char password[MAX_LENGTH + 1];
    int length = 0;
    int num_uppercase = 0;
    int num_lowercase = 0;
    int num_numbers = 0;
    int num_special_chars = 0;

    printf("Enter your password: ");
    fgets(password, MAX_LENGTH + 1, stdin);
    length = strlen(password);

    if (length < MIN_LENGTH || length > MAX_LENGTH) {
        printf("Password must be between %d and %d characters long.\n", MIN_LENGTH, MAX_LENGTH);
        return 1;
    }

    for (int i = 0; i < length; i++) {
        if (isupper(password[i])) {
            num_uppercase++;
        } else if (islower(password[i])) {
            num_lowercase++;
        } else if (isdigit(password[i])) {
            num_numbers++;
        } else if (password[i] == '!' || password[i] == '@' || password[i] == '#' || password[i] == '$' ||
                   password[i] == '%' || password[i] == '&' || password[i] == '*' || password[i] == '?') {
            num_special_chars++;
        }
    }

    if (num_uppercase < 1 || num_lowercase < 1 || num_numbers < 1 || num_special_chars < 1) {
        printf("Password must contain at least one uppercase letter, one lowercase letter, one number, and one special character.\n");
        return 1;
    }

    printf("Password is strong.\n");
    return 0;
}