//GPT-4o-mini DATASET v1.0 Category: Packet Capturer with pcap library ; Style: Linus Torvalds
#include <pcap.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <time.h>

#define MAX_PACKETS 100
#define BYTE_TO_KB(x) ((x) / 1024)

void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    // Cast the args (not used) and print the timestamp
    struct tm *ltime;
    char timestr[16]; // Space for timestamp string
    time_t local_tv_sec;

    local_tv_sec = header->ts.tv_sec;
    ltime = localtime(&local_tv_sec);
    strftime(timestr, sizeof(timestr), "%H:%M:%S", ltime);

    // Print packet info
    printf("%s - Packet Size: %d bytes\n", timestr, header->len);
    printf("Packet Data (Hex): ");
    
    for (int i = 0; i < header->len; i++) {
        printf("%02x ", packet[i]);
    }
    printf("\n\n");
}

void capture_packets(const char *interface) {
    char errbuf[PCAP_ERRBUF_SIZE];
    pcap_t *handle;

    // Open the session in promiscuous mode
    handle = pcap_open_live(interface, BUFSIZ, 1, 1000, errbuf);

    if (handle == NULL) {
        fprintf(stderr, "Could not open device %s: %s\n", interface, errbuf);
        exit(EXIT_FAILURE);
    }

    printf("Starting packet capture on %s...\n", interface);
    
    // Capture packets
    pcap_loop(handle, MAX_PACKETS, packet_handler, NULL);

    // Cleanup
    pcap_close(handle);
    printf("Finished capturing packets.\n");
}

int main(int argc, char *argv[]) {
    if (argc != 2) {
        fprintf(stderr, "Usage: %s <network_interface>\n", argv[0]);
        return EXIT_FAILURE;
    }

    const char *interface = argv[1];
    capture_packets(interface);
    
    return EXIT_SUCCESS;
}