//GPT-4o-mini DATASET v1.0 Category: Alien Invasion Probability Calculator ; Style: post-apocalyptic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_CITIES 10
#define THRESHOLD 50

typedef struct {
    char name[20];
    int population;
    int alien_invasion_odds; // Probability in percentage
} City;

void initialize_cities(City cities[]) {
    strcpy(cities[0].name, "City A");
    cities[0].population = 150000;
    cities[0].alien_invasion_odds = rand() % 100;

    strcpy(cities[1].name, "City B");
    cities[1].population = 300000;
    cities[1].alien_invasion_odds = rand() % 100;

    strcpy(cities[2].name, "City C");
    cities[2].population = 200000;
    cities[2].alien_invasion_odds = rand() % 100;

    strcpy(cities[3].name, "City D");
    cities[3].population = 120000;
    cities[3].alien_invasion_odds = rand() % 100;

    strcpy(cities[4].name, "City E");
    cities[4].population = 250000;
    cities[4].alien_invasion_odds = rand() % 100;

    strcpy(cities[5].name, "City F");
    cities[5].population = 80000;
    cities[5].alien_invasion_odds = rand() % 100;

    strcpy(cities[6].name, "City G");
    cities[6].population = 50000;
    cities[6].alien_invasion_odds = rand() % 100;

    strcpy(cities[7].name, "City H");
    cities[7].population = 600000;
    cities[7].alien_invasion_odds = rand() % 100;

    strcpy(cities[8].name, "City I");
    cities[8].population = 400000;
    cities[8].alien_invasion_odds = rand() % 100;

    strcpy(cities[9].name, "City J");
    cities[9].population = 100000;
    cities[9].alien_invasion_odds = rand() % 100;
}

void display_city_status(City cities[], int city_count) {
    printf("\n\n=== Post-Apocalyptic Alien Invasion Probability Status ===\n");
    
    for(int i = 0; i < city_count; i++) {
        printf("City: %s\n", cities[i].name);
        printf("Population: %d\n", cities[i].population);
        printf("Alien Invasion Probability: %d%%\n", cities[i].alien_invasion_odds);
        printf("Status: %s\n", (cities[i].alien_invasion_odds > THRESHOLD) ? "ALARMING!" : "Safe.");
        printf("-------------------------------------------------\n");
    }
}

void alert_cities_in_danger(City cities[], int city_count) {
    printf("\n\n=== ALERT: Cities in Danger of Alien Invasion ===\n");
    for(int i = 0; i < city_count; i++) {
        if(cities[i].alien_invasion_odds > THRESHOLD) {
            printf("Danger: %s with %d%% probability!\n", cities[i].name, cities[i].alien_invasion_odds);
        }
    }
}

int main() {
    srand(time(NULL)); // Seed random number generation
    City cities[MAX_CITIES];
    initialize_cities(cities);
    display_city_status(cities, MAX_CITIES);
    alert_cities_in_danger(cities, MAX_CITIES);
    
    return 0;
}