//GEMINI-pro DATASET v1.0 Category: Memory management ; Style: relaxed
#include <stdio.h>
#include <stdlib.h>

// Let's create a dynamic array of integers.
int *array;

// We'll use a function to allocate memory for the array.
void createArray(int size) {
    // Allocate memory for the array.
    array = (int *)malloc(size * sizeof(int));
    // Check if memory allocation was successful.
    if (array == NULL) {
        printf("Error allocating memory for the array.\n");
        exit(1);
    }
    // Initialize the array elements to 0.
    for (int i = 0; i < size; i++) {
        array[i] = 0;
    }
}

// Let's also create a function to free the memory allocated for the array.
void destroyArray() {
    // Free the memory allocated for the array.
    free(array);
    // Set the array pointer to NULL.
    array = NULL;
}

// Now, let's write a function to print the elements of the array.
void printArray(int size) {
    // Print the elements of the array.
    for (int i = 0; i < size; i++) {
        printf("%d ", array[i]);
    }
    printf("\n");
}

// Let's test our memory management functions.
int main() {
    // Create a dynamic array of 10 integers.
    createArray(10);

    // Print the elements of the array.
    printArray(10);

    // Destroy the array.
    destroyArray();

    return 0;
}