//MISTRAL-7B DATASET v1.0 Category: Network Topology Mapper ; Style: Romeo and Juliet
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NODES 10
#define MAX_LINKS 20
#define MAX_NAME_LEN 20

typedef struct {
    char name[MAX_NAME_LEN];
    int x, y;
} Node;

typedef struct {
    Node *node1;
    Node *node2;
    int weight;
} Link;

Node nodes[MAX_NODES];
Link links[MAX_LINKS];
int num_nodes = 0, num_links = 0;

void add_node(const char *name, int x, int y) {
    strcpy(nodes[num_nodes].name, name);
    nodes[num_nodes].x = x;
    nodes[num_nodes].y = y;
    num_nodes++;
}

void add_link(Node *node1, Node *node2, int weight) {
    links[num_links].node1 = node1;
    links[num_links].node2 = node2;
    links[num_links].weight = weight;
    num_links++;
}

void print_topology() {
    int i;
    printf("Topology Map:\n");
    for (i = 0; i < num_links; i++) {
        printf("%s --%d--> %s\n", links[i].node1->name, links[i].weight, links[i].node2->name);
    }
}

int main() {
    add_node("Romeo", 1, 1);
    add_node("Juliet", 3, 3);
    add_node("Mercutio", 2, 2);
    add_node("Tybalt", 4, 4);

    add_link(&nodes[0], &nodes[2], 5);
    add_link(&nodes[1], &nodes[2], 3);
    add_link(&nodes[1], &nodes[3], 1);
    add_link(&nodes[2], &nodes[3], 2);
    add_link(&nodes[0], &nodes[3], 7);

    print_topology();

    // Fate takes its course
    int i, j;
    for (i = 0; i < num_links; i++) {
        for (j = i + 1; j < num_links; j++) {
            if (links[i].weight > links[j].weight) {
                Link temp = links[i];
                links[i] = links[j];
                links[j] = temp;
            }
        }
    }

    printf("\nAfter Fate's Intervention:\n");
    print_topology();

    return 0;
}