//Code Llama-13B DATASET v1.0 Category: Appointment Scheduler ; Style: innovative
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_APPOINTMENTS 100

typedef struct {
    char name[50];
    int day;
    int month;
    int year;
    int hour;
    int minute;
} appointment_t;

appointment_t appointments[MAX_APPOINTMENTS];
int num_appointments = 0;

void add_appointment(const char* name, int day, int month, int year, int hour, int minute) {
    if (num_appointments >= MAX_APPOINTMENTS) {
        printf("Appointment list is full.\n");
        return;
    }

    strcpy(appointments[num_appointments].name, name);
    appointments[num_appointments].day = day;
    appointments[num_appointments].month = month;
    appointments[num_appointments].year = year;
    appointments[num_appointments].hour = hour;
    appointments[num_appointments].minute = minute;
    num_appointments++;
}

void display_appointments() {
    for (int i = 0; i < num_appointments; i++) {
        printf("%s - %d/%d/%d - %d:%d\n", appointments[i].name, appointments[i].day, appointments[i].month, appointments[i].year, appointments[i].hour, appointments[i].minute);
    }
}

void sort_appointments() {
    int i, j;
    appointment_t temp;

    for (i = 0; i < num_appointments; i++) {
        for (j = i + 1; j < num_appointments; j++) {
            if (appointments[i].day < appointments[j].day) {
                temp = appointments[i];
                appointments[i] = appointments[j];
                appointments[j] = temp;
            }
        }
    }
}

int main() {
    add_appointment("John", 2, 3, 2023, 10, 0);
    add_appointment("Alice", 1, 3, 2023, 12, 0);
    add_appointment("Bob", 3, 3, 2023, 14, 0);
    add_appointment("Eve", 4, 3, 2023, 16, 0);

    display_appointments();

    sort_appointments();

    display_appointments();

    return 0;
}