//Falcon-180B DATASET v1.0 Category: Client Server Application ; Style: Sherlock Holmes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

int main() {
    int server_socket, client_socket;
    struct sockaddr_in server_addr, client_addr;
    char message[100];

    // Create socket
    server_socket = socket(AF_INET, SOCK_STREAM, 0);
    if (server_socket == -1) {
        printf("Error creating socket\n");
        exit(1);
    }

    // Set server address
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(12345);
    server_addr.sin_addr.s_addr = htonl(INADDR_ANY);

    // Bind socket to address
    if (bind(server_socket, (struct sockaddr *)&server_addr, sizeof(server_addr)) == -1) {
        printf("Error binding socket\n");
        exit(1);
    }

    // Listen for connections
    if (listen(server_socket, 5) == -1) {
        printf("Error listening\n");
        exit(1);
    }

    // Accept a connection
    printf("Waiting for connection...\n");
    client_socket = accept(server_socket, (struct sockaddr *)&client_addr, sizeof(client_addr));
    if (client_socket == -1) {
        printf("Error accepting connection\n");
        exit(1);
    }

    // Send message to client
    strcpy(message, "Welcome to the Sherlock Holmes Server!");
    send(client_socket, message, strlen(message), 0);

    // Receive message from client
    memset(message, 0, sizeof(message));
    recv(client_socket, message, sizeof(message), 0);
    printf("Message from client: %s\n", message);

    // Close sockets
    close(client_socket);
    close(server_socket);

    return 0;
}