//Falcon-180B DATASET v1.0 Category: Error handling ; Style: ephemeral
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

#define MAX_SIZE 100

// Function to create a stack
void create_stack(int *stack, int size) {
    stack[0] = -1; // Initialize the top of the stack to -1
    for (int i = 1; i < size; i++) {
        stack[i] = 0; // Initialize the rest of the stack to 0
    }
}

// Function to check if the stack is full
bool is_stack_full(int *stack, int size) {
    return (stack[0] == size - 1);
}

// Function to check if the stack is empty
bool is_stack_empty(int *stack, int size) {
    return (stack[0] == -1);
}

// Function to push an element onto the stack
void push(int *stack, int *top, int size, int element) {
    if (is_stack_full(stack, size)) {
        printf("Stack overflow\n");
        exit(1);
    } else {
        *top += 1;
        stack[*top] = element;
    }
}

// Function to pop an element from the stack
int pop(int *stack, int *top, int size) {
    if (is_stack_empty(stack, size)) {
        printf("Stack underflow\n");
        exit(1);
    } else {
        int element = stack[*top];
        *top -= 1;
        return element;
    }
}

// Function to display the contents of the stack
void display_stack(int *stack, int size, int top) {
    printf("Stack contents:\n");
    for (int i = top; i >= 0; i--) {
        printf("%d ", stack[i]);
    }
    printf("\n");
}

int main() {
    int stack[MAX_SIZE];
    int top = -1;
    int size = 5;

    // Create the stack
    create_stack(stack, size);

    // Push some elements onto the stack
    push(stack, &top, size, 10);
    push(stack, &top, size, 20);
    push(stack, &top, size, 30);

    // Display the contents of the stack
    display_stack(stack, size, top);

    // Pop an element from the stack
    int popped_element = pop(stack, &top, size);
    printf("Popped element: %d\n", popped_element);

    // Display the contents of the stack again
    display_stack(stack, size, top);

    // Try to pop an element from an empty stack
    pop(stack, &top, size);

    return 0;
}