//Code Llama-13B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: peaceful
#include <stdio.h>
#include <stdlib.h>

#define MAX_PROCESSES 10
#define MAX_BURST_TIME 10

typedef struct {
    int pid;
    int arrival_time;
    int burst_time;
    int priority;
} Process;

void print_processes(Process processes[], int num_processes) {
    printf("Processes: \n");
    for (int i = 0; i < num_processes; i++) {
        printf("[%d] PID: %d, Arrival Time: %d, Burst Time: %d, Priority: %d\n", i, processes[i].pid, processes[i].arrival_time, processes[i].burst_time, processes[i].priority);
    }
    printf("\n");
}

int main() {
    Process processes[] = {
        {1, 0, 3, 1},
        {2, 2, 2, 2},
        {3, 5, 5, 3},
        {4, 6, 4, 1},
        {5, 9, 3, 2}
    };

    int num_processes = sizeof(processes) / sizeof(Process);

    print_processes(processes, num_processes);

    int current_time = 0;
    int total_burst_time = 0;

    while (total_burst_time < MAX_BURST_TIME) {
        for (int i = 0; i < num_processes; i++) {
            if (processes[i].arrival_time <= current_time) {
                printf("Process %d starts at time %d\n", processes[i].pid, current_time);
                total_burst_time += processes[i].burst_time;
                processes[i].arrival_time += processes[i].burst_time;
                printf("Process %d finishes at time %d\n", processes[i].pid, current_time + processes[i].burst_time);
            }
        }
        current_time++;
    }

    printf("Total Burst Time: %d\n", total_burst_time);

    return 0;
}