//MISTRAL-7B DATASET v1.0 Category: Dice Roller ; Style: careful
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_DICE 5
#define NUM_SIDES 6

// Define the Dice structure
typedef struct {
    int sides;
    int roll[NUM_DICE];
} Dice;

// Function to generate a random number
int randomNumberGenerator(int min, int max) {
    int randomNumber;
    randomNumber = rand() % (max - min + 1) + min;
    return randomNumber;
}

// Function to roll the dice
void rollDice(Dice *dice) {
    for (int i = 0; i < NUM_DICE; i++) {
        dice->roll[i] = randomNumberGenerator(1, NUM_SIDES);
    }
}

// Function to print the rolled dice
void printRolledDice(Dice dice) {
    printf("Rolled Dice:\n");
    for (int i = 0; i < NUM_DICE; i++) {
        printf("Dice %d rolled: %d\n", i + 1, dice.roll[i]);
    }
}

// Main function
int main() {
    // Initialize random seed
    srand(time(NULL));

    // Define a Dice variable
    Dice myDice;

    // Roll the dice
    rollDice(&myDice);

    // Print the rolled dice
    printRolledDice(myDice);

    return 0;
}