//Gemma-7B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: safe
#include <stdio.h>
#include <stdlib.h>

#define MAX_PROCESS 5

typedef struct Process
{
    int process_id;
    char name[20];
    int burst_time;
    int waiting_time;
    int turnaround_time;
} Process;

void calculate_waiting_time(Process *process)
{
    process->waiting_time = process->burst_time - 1;
}

void calculate_turnaround_time(Process *process)
{
    process->turnaround_time = process->waiting_time + process->burst_time;
}

int main()
{
    Process processes[MAX_PROCESS];

    // Create processes
    processes[0].process_id = 1;
    strcpy(processes[0].name, "Process A");
    processes[0].burst_time = 5;

    processes[1].process_id = 2;
    strcpy(processes[1].name, "Process B");
    processes[1].burst_time = 3;

    processes[2].process_id = 3;
    strcpy(processes[2].name, "Process C");
    processes[2].burst_time = 4;

    processes[3].process_id = 4;
    strcpy(processes[3].name, "Process D");
    processes[3].burst_time = 2;

    processes[4].process_id = 5;
    strcpy(processes[4].name, "Process E");
    processes[4].burst_time = 6;

    // Calculate waiting time and turnaround time for each process
    for (int i = 0; i < MAX_PROCESS; i++)
    {
        calculate_waiting_time(&processes[i]);
        calculate_turnaround_time(&processes[i]);
    }

    // Print processes
    for (int i = 0; i < MAX_PROCESS; i++)
    {
        printf("Process ID: %d\n", processes[i].process_id);
        printf("Process Name: %s\n", processes[i].name);
        printf("Burst Time: %d\n", processes[i].burst_time);
        printf("Waiting Time: %d\n", processes[i].waiting_time);
        printf("Turnaround Time: %d\n", processes[i].turnaround_time);
        printf("\n");
    }

    return 0;
}