//GEMINI-pro DATASET v1.0 Category: Network Packet Monitoring ; Style: detailed
#include <stdio.h>
#include <stdlib.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <pcap.h>

// Callback function for processing each packet
void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    // Extract packet header information
    struct in_addr src_addr, dst_addr;
    src_addr.s_addr = *((u_int32_t *)(packet + 12));
    dst_addr.s_addr = *((u_int32_t *)(packet + 16));

    // Print packet information
    printf("Packet received from %s to %s\n", inet_ntoa(src_addr), inet_ntoa(dst_addr));
    printf("Packet size: %d bytes\n", header->len);

    // Extract packet data and print first 100 bytes
    printf("Packet data:\n");
    for (int i = 0; i < 100 && i < header->len; i++) {
        printf("%02X ", packet[i]);
    }
    printf("\n");
}

int main() {
    // Initialize libpcap
    pcap_t *handle = pcap_open_live("eth0", BUFSIZ, 1, 1000, NULL);
    if (handle == NULL) {
        perror("pcap_open_live() failed");
        return EXIT_FAILURE;
    }

    // Set filter to capture all packets
    struct bpf_program bpf;
    if (pcap_compile(handle, &bpf, "tcp", 1, 0) != 0) {
        perror("pcap_compile() failed");
        pcap_close(handle);
        return EXIT_FAILURE;
    }
    if (pcap_setfilter(handle, &bpf) != 0) {
        perror("pcap_setfilter() failed");
        pcap_close(handle);
        return EXIT_FAILURE;
    }

    // Start packet capture
    pcap_loop(handle, 10, packet_handler, NULL);

    // Cleanup
    pcap_close(handle);
    return EXIT_SUCCESS;
}