//Falcon-180B DATASET v1.0 Category: Expense Tracker ; Style: light-weight
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_CATEGORIES 10
#define MAX_EXPENSES 100
#define MAX_NAME_LENGTH 50
#define MAX_AMOUNT_LENGTH 10

typedef struct expense {
    char name[MAX_NAME_LENGTH];
    char category[MAX_NAME_LENGTH];
    char amount[MAX_AMOUNT_LENGTH];
} expense_t;

expense_t expenses[MAX_EXPENSES];
char categories[MAX_CATEGORIES][MAX_NAME_LENGTH];
int num_categories = 0;
int num_expenses = 0;

void add_category(char* name) {
    if (num_categories >= MAX_CATEGORIES) {
        printf("Error: Too many categories.\n");
        return;
    }
    strcpy(categories[num_categories], name);
    num_categories++;
}

void add_expense(char* name, char* category, char* amount) {
    if (num_expenses >= MAX_EXPENSES) {
        printf("Error: Too many expenses.\n");
        return;
    }
    expense_t* expense = &expenses[num_expenses];
    strcpy(expense->name, name);
    strcpy(expense->category, category);
    strcpy(expense->amount, amount);
    num_expenses++;
}

void print_expenses() {
    printf("Expenses:\n");
    for (int i = 0; i < num_expenses; i++) {
        expense_t* expense = &expenses[i];
        printf("Name: %s\nCategory: %s\nAmount: %s\n", expense->name, expense->category, expense->amount);
    }
}

void print_categories() {
    printf("Categories:\n");
    for (int i = 0; i < num_categories; i++) {
        printf("%s\n", categories[i]);
    }
}

int main() {
    add_category("Food");
    add_category("Transportation");
    add_category("Entertainment");
    add_category("Clothing");

    add_expense("Groceries", "Food", "50.00");
    add_expense("Gas", "Transportation", "25.00");
    add_expense("Movie Ticket", "Entertainment", "10.00");
    add_expense("Shirt", "Clothing", "20.00");

    print_categories();
    print_expenses();

    return 0;
}