//Gemma-7B DATASET v1.0 Category: Medical Store Management System ; Style: mind-bending
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PRODUCTS 100
#define MAX_CUSTOMERS 50

typedef struct Product {
  char name[50];
  int quantity;
  float price;
} Product;

typedef struct Customer {
  char name[50];
  int age;
  float total_spent;
} Customer;

Product products[MAX_PRODUCTS];
Customer customers[MAX_CUSTOMERS];

void addProduct(Product product) {
  int i = 0;
  for (; i < MAX_PRODUCTS && products[i].name[0] != '\0'; i++) {}
  products[i] = product;
}

void addCustomer(Customer customer) {
  int i = 0;
  for (; i < MAX_CUSTOMERS && customers[i].name[0] != '\0'; i++) {}
  customers[i] = customer;
}

void updateProductQuantity(Product product, int quantity) {
  product.quantity = quantity;
}

void updateCustomerTotalSpent(Customer customer, float total_spent) {
  customer.total_spent = total_spent;
}

void printProducts() {
  int i = 0;
  for (; products[i].name[0] != '\0'; i++) {
    printf("%s: %d, %f\n", products[i].name, products[i].quantity, products[i].price);
  }
}

void printCustomers() {
  int i = 0;
  for (; customers[i].name[0] != '\0'; i++) {
    printf("%s, %d, %.2f\n", customers[i].name, customers[i].age, customers[i].total_spent);
  }
}

int main() {
  Product product1 = {"Product 1", 10, 10.0};
  addProduct(product1);

  Customer customer1 = {"Customer 1", 25, 200.0};
  addCustomer(customer1);

  updateProductQuantity(product1, 15);
  updateCustomerTotalSpent(customer1, 300.0);

  printProducts();
  printCustomers();

  return 0;
}