//GEMINI-pro DATASET v1.0 Category: Bitwise operations ; Style: authentic
#include <stdio.h>

int main() {
    // Initialize variables
    int num1 = 10;
    int num2 = 5;
    int result;

    // Bitwise AND (&)
    result = num1 & num2;
    printf("Bitwise AND: %d\n", result);  // Output: 0

    // Bitwise OR (|)
    result = num1 | num2;
    printf("Bitwise OR: %d\n", result);   // Output: 11

    // Bitwise XOR (^)
    result = num1 ^ num2;
    printf("Bitwise XOR: %d\n", result);  // Output: 11

    // Bitwise NOT (~)
    result = ~num1;
    printf("Bitwise NOT: %d\n", result);  // Output: -11

    // Bitwise Left Shift (<<)
    result = num1 << 2;
    printf("Bitwise Left Shift: %d\n", result);  // Output: 40

    // Bitwise Right Shift (>>)
    result = num1 >> 2;
    printf("Bitwise Right Shift: %d\n", result); // Output: 2

    // Combining bitwise and logical operators
    int flag = 1;
    if (num1 & flag) {
        printf("Flag is set\n");  // Output: Flag is set
    }

    // Bitwise Masking
    int mask = 0x0F; // Binary representation: 00001111
    result = num1 & mask;
    printf("Bitwise Masking: %d\n", result);  // Output: 10 (only the last 4 bits of num1)

    // Bitwise manipulation for data compression
    unsigned char compressedData[10];
    int num3 = 12345;

    // Compress num3 into compressedData
    compressedData[0] = (num3 >> 8) & 0xFF;  // Store the upper 8 bits
    compressedData[1] = num3 & 0xFF;       // Store the lower 8 bits

    // Decompress num3 from compressedData
    num3 = (compressedData[0] << 8) | compressedData[1];

    // Bitwise manipulation for bit manipulation
    int bitPosition = 3;
    result = num1 | (1 << bitPosition);
    printf("Bitwise manipulation for bit manipulation: %d\n", result);  // Output: 14 (num1 with the bit at position 3 set to 1)

    return 0;
}