//Falcon-180B DATASET v1.0 Category: Traffic Light Controller ; Style: complex
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <pthread.h>

#define RED_LIGHT 1
#define YELLOW_LIGHT 2
#define GREEN_LIGHT 3

#define SECONDS_PER_CYCLE 15
#define NUM_CYCLES 10

int current_light = RED_LIGHT;
int num_cycles_left = NUM_CYCLES;

void *traffic_light_controller(void *arg) {
    while (num_cycles_left > 0) {
        switch (current_light) {
            case RED_LIGHT:
                printf("Red light on\n");
                current_light = YELLOW_LIGHT;
                break;
            case YELLOW_LIGHT:
                printf("Yellow light on\n");
                current_light = GREEN_LIGHT;
                break;
            case GREEN_LIGHT:
                printf("Green light on\n");
                current_light = RED_LIGHT;
                break;
        }
        sleep(SECONDS_PER_CYCLE);
        num_cycles_left--;
    }
    return NULL;
}

int main() {
    pthread_t thread_id;
    int rc;

    rc = pthread_create(&thread_id, NULL, traffic_light_controller, NULL);
    if (rc) {
        printf("Error: unable to start thread, %d\n", rc);
        exit(-1);
    }

    printf("Traffic light controller started\n");
    while (num_cycles_left > 0) {
        sleep(SECONDS_PER_CYCLE);
        num_cycles_left--;
    }

    printf("Traffic light controller stopped\n");
    return 0;
}