//GPT-4o-mini DATASET v1.0 Category: Secure Password Generator ; Style: safe
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#define PASSWORD_LENGTH 16
#define NUM_SPECIAL_CHARACTERS 10

const char uppercase[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
const char lowercase[] = "abcdefghijklmnopqrstuvwxyz";
const char digits[] = "0123456789";
const char special_chars[] = "!@#$%^&*()-_=+[]{}|;:,.<>?";

void shuffle(char *array, size_t n) {
    if (n > 1) {
        for (size_t i = 0; i < n - 1; i++) {
            size_t j = i + rand() / (RAND_MAX / (n - i) + 1);
            char t = array[j];
            array[j] = array[i];
            array[i] = t;
        }
    }
}

void generate_password(char *password) {
    int i;
    int password_index = 0;

    // Ensure at least one character of each type
    password[password_index++] = uppercase[rand() % strlen(uppercase)];
    password[password_index++] = lowercase[rand() % strlen(lowercase)];
    password[password_index++] = digits[rand() % strlen(digits)];
    password[password_index++] = special_chars[rand() % strlen(special_chars)];

    // Fill the rest of the password length with random characters from all categories
    const char *all_chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()-_=+[]{}|;:,.<>?";
    for (i = password_index; i < PASSWORD_LENGTH; i++) {
        password[i] = all_chars[rand() % strlen(all_chars)];
    }

    // Shuffle the password to avoid any predictable patterns
    shuffle(password, PASSWORD_LENGTH);
    
    // Null terminate the password string
    password[PASSWORD_LENGTH] = '\0';
}

int main() {
    // Seed the random number generator
    srand(time(NULL));

    // Allocate memory for password
    char password[PASSWORD_LENGTH + 1];

    // Generate password
    generate_password(password);

    // Output the generated password
    printf("Generated Password: %s\n", password);

    return 0;
}