//Falcon-180B DATASET v1.0 Category: Smart home light control ; Style: Ada Lovelace
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>

#define NUM_ROOMS 3
#define NUM_LIGHTS 2

struct Room {
    char name[50];
    bool lightOn[NUM_LIGHTS];
};

void turnLightOn(struct Room *room, int lightNum) {
    if (lightNum >= 0 && lightNum < NUM_LIGHTS) {
        room->lightOn[lightNum] = true;
        printf("Turned light on in room %s\n", room->name);
    } else {
        printf("Invalid light number\n");
    }
}

void turnLightOff(struct Room *room, int lightNum) {
    if (lightNum >= 0 && lightNum < NUM_LIGHTS) {
        room->lightOn[lightNum] = false;
        printf("Turned light off in room %s\n", room->name);
    } else {
        printf("Invalid light number\n");
    }
}

void printRoomLights(struct Room *room) {
    printf("Room %s:\n", room->name);
    for (int i = 0; i < NUM_LIGHTS; i++) {
        if (room->lightOn[i]) {
            printf("\tLight %d is on\n", i+1);
        } else {
            printf("\tLight %d is off\n", i+1);
        }
    }
}

int main() {
    struct Room rooms[NUM_ROOMS];

    // Initialize rooms
    strcpy(rooms[0].name, "Living Room");
    strcpy(rooms[1].name, "Bedroom");
    strcpy(rooms[2].name, "Kitchen");

    // Initialize lights
    for (int i = 0; i < NUM_ROOMS; i++) {
        for (int j = 0; j < NUM_LIGHTS; j++) {
            rooms[i].lightOn[j] = false;
        }
    }

    // Example usage
    turnLightOn(&rooms[0], 0);
    turnLightOff(&rooms[1], 1);
    printRoomLights(&rooms[2]);

    return 0;
}