//Falcon2-11B DATASET v1.0 Category: Password Strength Checker ; Style: secure
#include <stdio.h>
#include <string.h>

#define MIN_LENGTH 8
#define MAX_LENGTH 12
#define MIN_UPPER 1
#define MAX_UPPER 1
#define MIN_LOWER 1
#define MAX_LOWER 1
#define MIN_DIGIT 1
#define MAX_DIGIT 1
#define MIN_SPECIAL 1
#define MAX_SPECIAL 1

int isPasswordStrong(char *password) {
    int length = strlen(password);
    if (length < MIN_LENGTH) return 0;

    int upper = 0;
    int lower = 0;
    int digit = 0;
    int special = 0;

    for (int i = 0; i < length; i++) {
        if (isupper(password[i])) upper++;
        else if (islower(password[i])) lower++;
        else if (isdigit(password[i])) digit++;
        else if (isalnum(password[i])) special++;
    }

    if (upper < MIN_UPPER || upper > MAX_UPPER || lower < MIN_LOWER || lower > MAX_LOWER || digit < MIN_DIGIT || digit > MAX_DIGIT || special < MIN_SPECIAL || special > MAX_SPECIAL) {
        return 0;
    }

    return 1;
}

int main() {
    char password[13];
    printf("Enter password: ");
    fgets(password, 13, stdin);
    password[strcspn(password, "\n")] = 0;

    if (isPasswordStrong(password)) {
        printf("Strong password.\n");
    } else {
        printf("Weak password.\n");
    }

    return 0;
}