//GEMINI-pro DATASET v1.0 Category: Geometric algorithms ; Style: scientific
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// Structure to represent a point in 2D space
typedef struct Point {
    double x;
    double y;
} Point;

// Structure to represent a line segment
typedef struct LineSegment {
    Point p1;
    Point p2;
} LineSegment;

// Function to calculate the distance between two points
double distance(Point p1, Point p2) {
    return sqrt(pow(p2.x - p1.x, 2) + pow(p2.y - p1.y, 2));
}

// Function to check if a point is on a line segment
int is_on_line_segment(Point p, LineSegment l) {
    double dx1 = l.p2.x - l.p1.x;
    double dy1 = l.p2.y - l.p1.y;
    double dx2 = p.x - l.p1.x;
    double dy2 = p.y - l.p1.y;
    double cross = dx1 * dy2 - dy1 * dx2;
    if (fabs(cross) > 1e-9) {
        return 0;
    }
    double dot = dx1 * dx2 + dy1 * dy2;
    if (dot < 0 || dot > dx1 * dx1 + dy1 * dy1) {
        return 0;
    }
    return 1;
}

// Function to check if two line segments intersect
int do_line_segments_intersect(LineSegment l1, LineSegment l2) {
    if (is_on_line_segment(l1.p1, l2) || is_on_line_segment(l1.p2, l2) ||
        is_on_line_segment(l2.p1, l1) || is_on_line_segment(l2.p2, l1)) {
        return 1;
    }
    double dx1 = l1.p2.x - l1.p1.x;
    double dy1 = l1.p2.y - l1.p1.y;
    double dx2 = l2.p2.x - l2.p1.x;
    double dy2 = l2.p2.y - l2.p1.y;
    double cross = dx1 * dy2 - dy1 * dx2;
    if (fabs(cross) > 1e-9) {
        double s1 = (l2.p1.x - l1.p1.x) * dy1 / cross;
        double s2 = (l2.p1.y - l1.p1.y) * dx1 / cross;
        if (s1 >= 0 && s1 <= 1 && s2 >= 0 && s2 <= 1) {
            return 1;
        }
    }
    return 0;
}

int main() {
    // Define two line segments
    LineSegment l1 = {{0, 0}, {1, 1}};
    LineSegment l2 = {{0, 1}, {1, 0}};

    // Check if the line segments intersect
    int intersect = do_line_segments_intersect(l1, l2);

    // Print the result
    printf("Do the line segments intersect? %s\n", intersect ? "Yes" : "No");

    return 0;
}