//Code Llama-13B DATASET v1.0 Category: Simple Web Server ; Style: standalone
/*
 * Simple Web Server
 *
 * A simple web server that listens on port 80 and responds with "Hello, World!"
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define BUFFER_SIZE 1024

int main(int argc, char *argv[]) {
    int sock, client;
    struct sockaddr_in server, client_addr;
    socklen_t client_len = sizeof(client_addr);
    char buffer[BUFFER_SIZE];

    // Create the socket
    sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        perror("Error creating socket");
        exit(1);
    }

    // Set up the server address
    server.sin_family = AF_INET;
    server.sin_addr.s_addr = INADDR_ANY;
    server.sin_port = htons(80);

    // Bind the socket to the server address
    if (bind(sock, (struct sockaddr *)&server, sizeof(server)) < 0) {
        perror("Error binding socket");
        exit(1);
    }

    // Listen for incoming connections
    if (listen(sock, 3) < 0) {
        perror("Error listening on socket");
        exit(1);
    }

    // Accept incoming connections
    client = accept(sock, (struct sockaddr *)&client_addr, &client_len);
    if (client < 0) {
        perror("Error accepting connection");
        exit(1);
    }

    // Read the request
    memset(buffer, 0, BUFFER_SIZE);
    int bytes_read = read(client, buffer, BUFFER_SIZE);
    if (bytes_read < 0) {
        perror("Error reading from socket");
        exit(1);
    }

    // Print the request
    printf("Request:\n%s\n", buffer);

    // Send the response
    char response[] = "HTTP/1.1 200 OK\r\nContent-Type: text/html\r\n\r\nHello, World!";
    int bytes_sent = write(client, response, strlen(response));
    if (bytes_sent < 0) {
        perror("Error writing to socket");
        exit(1);
    }

    // Close the connection
    close(client);

    return 0;
}