//Falcon-180B DATASET v1.0 Category: Stock market tracker ; Style: multivariable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_COMPANIES 100
#define MAX_SYMBOLS 10

typedef struct {
    char symbol[MAX_SYMBOLS];
    float price;
} Stock;

Stock companies[MAX_COMPANIES];
int num_companies = 0;

void add_company(char* symbol, float price) {
    if (num_companies >= MAX_COMPANIES) {
        printf("Error: Maximum number of companies reached.\n");
        return;
    }

    strcpy(companies[num_companies].symbol, symbol);
    companies[num_companies].price = price;
    num_companies++;
}

void remove_company(char* symbol) {
    int i;

    for (i = 0; i < num_companies; i++) {
        if (strcmp(companies[i].symbol, symbol) == 0) {
            memmove(&companies[i], &companies[i+1], sizeof(Stock) * (num_companies - i - 1));
            num_companies--;
            break;
        }
    }
}

void update_price(char* symbol, float price) {
    int i;

    for (i = 0; i < num_companies; i++) {
        if (strcmp(companies[i].symbol, symbol) == 0) {
            companies[i].price = price;
            break;
        }
    }
}

void print_companies() {
    int i;

    for (i = 0; i < num_companies; i++) {
        printf("%s: $%.2f\n", companies[i].symbol, companies[i].price);
    }
}

int main() {
    add_company("AAPL", 150.00);
    add_company("GOOG", 1000.00);
    add_company("MSFT", 50.00);

    print_companies();

    update_price("AAPL", 160.00);

    print_companies();

    remove_company("MSFT");

    print_companies();

    return 0;
}