//GPT-4o-mini DATASET v1.0 Category: Packet Capturer with pcap library ; Style: immersive
#include <stdio.h>
#include <stdlib.h>
#include <pcap.h>
#include <arpa/inet.h>
#include <netinet/ip.h>
#include <netinet/udp.h>
#include <netinet/tcp.h>
#include <netinet/ip_icmp.h>
#include <string.h>

void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    struct ip *ip_header = (struct ip *)(packet + 14); // Skip Ethernet header
    char src_ip[INET_ADDRSTRLEN], dst_ip[INET_ADDRSTRLEN];

    inet_ntop(AF_INET, &(ip_header->ip_src), src_ip, INET_ADDRSTRLEN);
    inet_ntop(AF_INET, &(ip_header->ip_dst), dst_ip, INET_ADDRSTRLEN);

    printf("Packet captured:\n");
    printf("Source IP: %s\n", src_ip);
    printf("Destination IP: %s\n", dst_ip);
    printf("Protocol: %d\n", ip_header->ip_p);

    // Check protocol type
    switch (ip_header->ip_p) {
        case IPPROTO_TCP:
            printf("Protocol Type: TCP\n");
            break;
        case IPPROTO_UDP:
            printf("Protocol Type: UDP\n");
            break;
        case IPPROTO_ICMP:
            printf("Protocol Type: ICMP\n");
            break;
        default:
            printf("Protocol Type: Unknown\n");
    }
    printf("------------------------------------------\n");
}

void capture_packets(char *dev) {
    char errbuf[PCAP_ERRBUF_SIZE];
    pcap_t *handle = pcap_open_live(dev, BUFSIZ, 1, 1000, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Couldn't open device %s: %s\n", dev, errbuf);
        exit(EXIT_FAILURE);
    }

    printf("Capturing packets on device: %s\n", dev);
    pcap_loop(handle, 10, packet_handler, NULL);

    pcap_close(handle);
}

int main(int argc, char *argv[]) {
    char *dev = pcap_lookupdev(NULL);
    if (dev == NULL) {
        fprintf(stderr, "No device found: %s\n", pcap_geterr(dev));
        return EXIT_FAILURE;
    }

    printf("Using device: %s\n", dev);
    capture_packets(dev);

    return EXIT_SUCCESS;
}