//GPT-4o-mini DATASET v1.0 Category: Building a IMAP Client ; Style: paranoid
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <curl/curl.h>
#include <openssl/ssl.h>
#include <openssl/err.h>

#define MAX_EMAIL_LENGTH 256
#define MAX_PASS_LENGTH 256
#define MAX_RESPONSE_LENGTH 1024
#define MAX_MAILBOX_LENGTH 1024

typedef struct {
    char *data;
    size_t size;
} ResponseData;

size_t WriteCallback(void *contents, size_t size, size_t nmemb, ResponseData *userp) {
    size_t total_size = size * nmemb;
    userp->data = realloc(userp->data, userp->size + total_size + 1);
    if(userp->data == NULL) {
        fprintf(stderr, "Failed to allocate memory.\n");
        return 0;
    }
    memcpy(&(userp->data[userp->size]), contents, total_size);
    userp->size += total_size;
    userp->data[userp->size] = '\0';
    return total_size;
}

void cleanup(ResponseData *response) {
    free(response->data);
    response->data = NULL;
    response->size = 0;
}

void print_error(const char *msg) {
    fprintf(stderr, "Error: %s\n", msg);
}

void paranoid_login(CURL *curl, const char *username, const char *password) {
    if (!username || !password) {
        print_error("Username or password cannot be NULL.");
        return;
    }

    CURLcode res;
    ResponseData response = {NULL, 0};

    char url[MAX_RESPONSE_LENGTH];
    snprintf(url, sizeof(url), "imap://%s@imap.example.com", username);

    curl_easy_setopt(curl, CURLOPT_URL, url);
    curl_easy_setopt(curl, CURLOPT_USERNAME, username);
    curl_easy_setopt(curl, CURLOPT_PASSWORD, password);
    curl_easy_setopt(curl, CURLOPT_USE_SSL, CURLUSESSL_ALL);
    curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, WriteCallback);
    curl_easy_setopt(curl, CURLOPT_WRITEDATA, &response);
    
    res = curl_easy_perform(curl);
    if (res != CURLE_OK) {
        print_error(curl_easy_strerror(res));
    } else {
        printf("Login was successful! Response: %s\n", response.data);
    }

    cleanup(&response);
}

void list_mailboxes(CURL *curl) {
    // This function demonstrates paranoid pattern by checking for NULL values.
    ResponseData response = {NULL, 0};
    CURLcode res;

    curl_easy_setopt(curl, CURLOPT_URL, "imap://imap.example.com/mailbox/");
    curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, WriteCallback);
    curl_easy_setopt(curl, CURLOPT_WRITEDATA, &response);

    res = curl_easy_perform(curl);
    if (res != CURLE_OK) {
        print_error(curl_easy_strerror(res));
    } else {
        printf("Mailboxes: %s\n", response.data);
    }

    cleanup(&response);
}

void fetch_headers(CURL *curl, const char *mailbox) {
    // More paranoia! Ensure mailbox exists.
    if (!mailbox) {
        print_error("Mailbox cannot be NULL.");
        return;
    }

    ResponseData response = {NULL, 0};
    CURLcode res;

    char mailbox_url[MAX_MAILBOX_LENGTH];
    snprintf(mailbox_url, sizeof(mailbox_url), "imap://imap.example.com/%s", mailbox);
   
    curl_easy_setopt(curl, CURLOPT_URL, mailbox_url);
    curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, WriteCallback);
    curl_easy_setopt(curl, CURLOPT_WRITEDATA, &response);

    res = curl_easy_perform(curl);
    if (res != CURLE_OK) {
        print_error(curl_easy_strerror(res));
    } else {
        printf("Fetched headers: %s\n", response.data);
    }

    cleanup(&response);
}

int main() {
    const char *username = getenv("IMAP_USER");
    const char *password = getenv("IMAP_PASS");
    if (!username || !password) {
        print_error("Environment variables IMAP_USER and IMAP_PASS must be set.");
        return EXIT_FAILURE;
    }

    CURL *curl = curl_easy_init();
    if (!curl) {
        print_error("Failed to initiate CURL.");
        return EXIT_FAILURE;
    }

    paranoid_login(curl, username, password);
    list_mailboxes(curl);
    fetch_headers(curl, "INBOX");

    curl_easy_cleanup(curl);
    return EXIT_SUCCESS;
}