//Gemma-7B DATASET v1.0 Category: Stock market tracker ; Style: enthusiastic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_STOCK_NUM 10

typedef struct Stock
{
    char name[20];
    double currentPrice;
    double previousPrice;
    double change;
} Stock;

void calculateChange(Stock *stock)
{
    stock->change = (stock->currentPrice - stock->previousPrice) / stock->previousPrice * 100.0;
}

int main()
{
    Stock stocks[MAX_STOCK_NUM] = {
        {"Apple Inc.", 140.25, 138.12, 0.0},
        {"Microsoft Corp.", 250.0, 248.75, 0.0},
        {"Amazon Inc.", 180.0, 178.25, 0.0},
        {"Tesla Inc.", 800.0, 780.0, 0.0},
        {"Google Inc.", 220.0, 218.50, 0.0},
        {"Ford Motor Company", 12.50, 11.25, 0.0},
        {"Toyota Motor Corporation", 16.25, 15.00, 0.0},
        {"Honda Motor Company", 18.75, 17.50, 0.0},
        {"Chrysler LLC", 10.25, 9.00, 0.0},
        {"General Motors Company", 12.00, 10.50, 0.0}
    };

    for (int i = 0; i < MAX_STOCK_NUM; i++)
    {
        calculateChange(&stocks[i]);
    }

    printf("Stock Market Tracker:\n");
    printf("-------------------\n");
    printf("Stock Name | Current Price | Previous Price | Change |\n");
    printf("-------------------\n");

    for (int i = 0; i < MAX_STOCK_NUM; i++)
    {
        printf("%s | %.2lf | %.2lf | %.2lf%% |\n", stocks[i].name, stocks[i].currentPrice, stocks[i].previousPrice, stocks[i].change);
    }

    printf("\n");
    printf("Total Number of Stocks: %d\n", MAX_STOCK_NUM);

    return 0;
}